---
generated_at: 2026-01-20 16:05:00
metrics:
  claims_total: 32
  claims_with_evidence: 31
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：12-Simple Browser 2 (Callback)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：31 / 32、根拠なし：1
- 優先レビュー（高）
  1. **ImageListのアイコンデータ詳細**：バイナリファイルのため内容確認困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Examples/IO Examples/SimpleBrowser2/Form1.frm`（行1-228）
- E-02: `Examples/IO Examples/SimpleBrowser2/Module1.bas`（行1-59）
- E-03: `Examples/IO Examples/SimpleBrowser2/SimpleBrowser2.vbp`（行1-32）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（行13）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（行93-99）
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名はSimple Browser 2 (Uses a Callback method for sorting) | E-01 行5, E-04 | ○ |
| C-02 | ファイルシステムブラウザ画面（コールバックソート版） | E-01 行5, E-04 | ○ |
| C-03 | DirectoryInfoでディレクトリ情報取得 | E-01 行94, E-05 | ○ |
| C-04 | FileInfoでファイル情報取得 | E-01 行130-131, E-05 | ○ |
| C-05 | DriveInfoでドライブ準備状態確認 | E-01 行97-102, E-05 | ○ |
| C-06 | Environment.GetLogicalDrivesでドライブ一覧取得 | E-01 行175, E-05 | ○ |
| C-07 | CorArray.Sortでコールバック関数を使用 | E-01 行135, E-02 行36 | ○ |
| C-08 | CorString.Formatで文字列フォーマット | E-01 行100, 154 | ○ |
| C-09 | Ceiling関数でファイルサイズ計算 | E-01 行154 | ○ |
| C-10 | SortDirection列挙型（Ascending、Descending） | E-02 行4-7 | ○ |
| C-11 | SortColumn変数でソート列を管理 | E-02 行10 | ○ |
| C-12 | SortOrder変数でソート順を管理 | E-02 行16 | ○ |
| C-13 | FileInfoComparerコールバック関数 | E-02 行36-58 | ○ |
| C-14 | Name列はCorString.CompareでOrdinalIgnoreCase比較 | E-02 行44 | ○ |
| C-15 | Size列はSgn関数で比較 | E-02 行47 | ○ |
| C-16 | Modified列はCompareToで比較 | E-02 行50 | ○ |
| C-17 | Descendingの場合は結果を符号反転 | E-02 行57 | ○ |
| C-18 | ListViewのカラムはName、Size、Date Modified | E-01 行191-193 | ○ |
| C-19 | Size列は右寄せ（lvwColumnRight） | E-01 行192 | ○ |
| C-20 | Form_LoadでShowDrives呼び出し | E-01 行196 | ○ |
| C-21 | Form_LoadでShowSubDirectories呼び出し | E-01 行197 | ○ |
| C-22 | TreeView1_Clickでノード選択処理 | E-01 行224-226 | ○ |
| C-23 | ListView1_ColumnClickでソート設定変更 | E-01 行203-219 | ○ |
| C-24 | ドライブ未準備時にMsgBox表示 | E-01 行100-102 | ○ |
| C-25 | ImageList1にClosedとOpenアイコン | E-01 行26-36 | ○ |
| C-26 | MSCOMCTL.OCXが必要 | E-03 行4 | ○ |
| C-27 | VBCorLib 3.0への参照が必要 | E-03 行3 | ○ |
| C-28 | スタートアップフォームはForm1 | E-03 行7 | ○ |
| C-29 | プロジェクト名はSimpleBrowser2 | E-03 行9 | ○ |
| C-30 | ファイルサイズはKB単位でN0書式 | E-01 行154 | ○ |
| C-31 | LastAccessTimeはToString()で文字列変換 | E-01 行164 | ○ |
| C-32 | ImageListアイコンの詳細内容 | E-01 行29,33（参照のみ） | △ |

## 4) 不足情報（Unknown / Missing）
- C-32: Form1.frxバイナリファイル内のアイコンデータ詳細
  - 候補：Form1.frxのバイナリ解析 / VB6 IDEでの確認

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：ソースコードから直接確認可能な内容が大半
- Module1.basの変数がPublicで宣言されているため、マルチスレッド環境では注意が必要（VB6は基本シングルスレッドのため実用上は問題なし）

## 6) レビュアーチェックリスト（最小）
- [ ] Form1.frmの行番号が実際のソースと一致するか確認
- [ ] Module1.basのFileInfoComparer関数の引数がByRefで宣言されているか確認
- [ ] 画面機能マッピングとの整合性確認
- [ ] Simple Browser（No.14）との差異が明確に記述されているか確認
